%Test the method obj.read_solutions
function test_suite = testReadSolutions %#ok<*STOUT>
initTestSuite;

function testCase = setup
testCase.fname = 'dummyDataFile';
warning('off','MATLAB:DELETE:FileNotFound')
delete(testCase.fname)
warning('on','MATLAB:DELETE:FileNotFound')
polysyms('x','y')
obj = BertiniLab('function_def',[x^2-1; x+y-1],'variable_group',[x y]);
testCase.poly_system = solve(obj);

function testNoArguments(~) %#ok<*DEFNU>
obj = BertiniLab;
f = @() obj.read_solutions;
assertExceptionThrown(f,'MATLAB:minrhs')

function testNoDataFile(testCase)
delete('raw_data')
f = @() testCase.poly_system.read_solutions('raw_data');
assertExceptionThrown(f,'BertiniLab:read_solutions:openError')

function testNoFile(testCase) %#ok<*DEFNU>
obj = BertiniLab;
f = @() obj.read_solutions(testCase.fname);
assertExceptionThrown(f,'BertiniLab:read_solutions:openError')

function testNoSolutions(testCase)
data = testCase.poly_system.read_solutions('singular_solutions');
assert(isempty(data))

function testNonsingularSolutions(testCase)
fid = fopen('nonsingular_solutions','w');
fprintf(fid,'1\n\n');
x = [1 2; 3 4];
fprintf(fid,'%17.16f %17.16f\n',x.');
fclose(fid);
data = testCase.poly_system.read_solutions('nonsingular_solutions');
assertEqual(data,polysym({'1.0000000000000000+2.0000000000000000*I'; ...
    '3.0000000000000000+4.0000000000000000*I'}))

function testNoMainData(testCase)
delete('main_data')
fid = fopen('nonsingular_solutions','w');
fprintf(fid,'1\n\n');
x = [1 2; 3 4];
fprintf(fid,'%17.16f %17.16f\n',x.');
fclose(fid);
data = testCase.poly_system.read_solutions('nonsingular_solutions');
assertEqual(data,polysym({'1.0000000000000000+2.0000000000000000*I'; ...
    '3.0000000000000000+4.0000000000000000*I'}))

function testRawSolutions(testCase)
% Special case because raw_solutions has path numbers
fid = fopen('raw_solutions','w');
fprintf(fid,'1\n\n0\n');
x = [1 2; 3 4];
fprintf(fid,'%17.16f %17.16f\n',x.');
fclose(fid);
data = testCase.poly_system.read_solutions('raw_solutions');
assertEqual(data,polysym({'1.0000000000000000+2.0000000000000000*I'; ...
    '3.0000000000000000+4.0000000000000000*I'}))

function testRawSolutionsWrongPathNumber(testCase)
fid = fopen('raw_solutions','w');
fprintf(fid,'1\n\n1\n'); % should be path 0
x = rand(2);
fprintf(fid,'%17.16f %17.16f\n',x.');
fclose(fid);
f = @() testCase.poly_system.read_solutions('raw_solutions');
assertExceptionThrown(f,'BertiniLab:read_solutions:wrongNumber')

function testMultihomogeneous(~)
% Make sure number of variables is correct in multihomogenous
% case
polysyms mu0 lambda; % Use 'mu0' because 'mu' is a Matlab toolbox command
v = polysym('v',[1 2]);
fdef = polysym('f',[1 2]);
A = [1 2; 2 4]; B = [4 -2; -2 1];
fval = mu0*A*v.' - lambda*B*v.';
poly_multihomo = BertiniLab('function_def',fdef(:),'function_def',fval(:), ...
    'hom_variable_group',{[mu0 lambda],v});
poly_multihomo = solve(poly_multihomo);

fid = fopen('nonsingular_solutions','w');
fprintf(fid,'1\n\n');
x = [1 3 5 7; 2 3 6 8].';
fprintf(fid,'%17.16f %17.16f\n',x.');
fclose(fid);
data = poly_multihomo.read_solutions('nonsingular_solutions');
assertEqual(data,polysym({'1.0000000000000000+2.0000000000000000*I'; ...
    '3.0000000000000000+3.0000000000000000*I'; ...
    '5.0000000000000000+6.0000000000000000*I'; ...
    '7.0000000000000000+8.0000000000000000*I'}))

function teardown(testCase)
warning('off','MATLAB:DELETE:FileNotFound')
delete(testCase.fname)
warning('on','MATLAB:DELETE:FileNotFound')
BertiniClean
